
#define NUM_REMOTE_FNS 26
#define NUM_REMOTE_CODES 4

typedef struct {
  const char* fn;
  unsigned long codes[NUM_REMOTE_CODES];
} remote_code_rom;

typedef struct {
  const char* fn;
  unsigned short lower_codes[NUM_REMOTE_CODES];
  unsigned char upper_codes[NUM_REMOTE_CODES];
} remote_code_ram;

extern remote_code_ram remote_codes[NUM_REMOTE_FNS];

void restore_default_remote_codes();
const char* get_remote_control_function(unsigned long code);
